#include "../mdk/mdk.h"
#include <windows.h>

#pragma optimize ("awy", on) 

CMachineParameter const paraLeftGain =
{
	pt_byte,
	"Gain-Left",
	"Left Gain",
	0,
	0xFE,
	0xFF,
	MPF_STATE,
	0xFE
};

CMachineParameter const paraRightGain =
{
	pt_byte,
	"Gain-Right",
	"Right Gain",
	0,
	0xFE,
	0xFF,
	MPF_STATE,
	0xFE
};

CMachineParameter const *pParameters[] = { &paraLeftGain, &paraRightGain };
CMachineAttribute const *pAttributes[] = { NULL };

#pragma pack(1)		

class gvals
{
public:
	byte leftgain;
	byte rightgain;
};

#pragma pack()


CMachineInfo const MacInfo = 
{
	MT_EFFECT,
	MI_VERSION,	
	MIF_DOES_INPUT_MIXING,
	0,										// min tracks
	0,										// max tracks
	2,										// numGlobalParameters
	0,										// numTrackParameters
	pParameters,
	0,
	pAttributes,
	"CyanPhase Mono",								// name
	"Mono",											// short name
	"Edward L. Blake",								// author
	"&About..."
};

class mi;

class miex : public CMDKMachineInterfaceEx 
{
public:
	virtual void AddInput(char const *macname, bool stereo);	// called when input is added to a machine
	virtual void DeleteInput(char const *macename);			
	virtual void RenameInput(char const *macoldname, char const *macnewname); 
	virtual void SetInputChannels(char const *macname, bool stereo); //{}
	virtual void Input(float *psamples, int numsamples, float amp); // if MIX_DOES_INPUT_MIXING
	virtual bool HandleInput(int index, int amp, int pan); //{ return false; }
public:

	mi *pmi;
};

class mi : public CMDKMachineInterface
{
public:
	mi();
	virtual ~mi();
	virtual void Tick();
	virtual void MDKInit(CMachineDataInput * const pi);
	virtual bool MDKWork(float *psamples, int numsamples, int const mode);
	virtual bool MDKWorkStereo(float *psamples, int numsamples, int const mode);
	virtual void Command(int const i);
	virtual void MDKSave(CMachineDataOutput * const po);
	virtual char const *DescribeValue(int const param, int const value);

public:
	virtual CMDKMachineInterfaceEx *GetEx() { return &ex; }
	virtual void OutputModeChanged(bool stereo) {}
	
	float thearray[1024];
	float leftgain, rightgain;

public:
	miex ex;

public:

	gvals gval;

};

void miex::AddInput(char const *macname, bool stereo) { }
void miex::DeleteInput(char const *macename) { }
void miex::RenameInput(char const *macoldname, char const *macnewname) { }
void miex::SetInputChannels(char const *macname, bool stereo) { }
void miex::Input(float *psamples, int numsamples, float amp) {
	int i;
	for (i = 0; i < numsamples; i++) {
		pmi->thearray[i] = pmi->thearray[i] + (((pmi->leftgain * *psamples++) + (pmi->rightgain * *psamples++)) / 2.0f) * amp;
	}
}
bool miex::HandleInput(int index, int amp, int pan) { return false; }

mi::mi() {  GlobalVals = &gval; }
mi::~mi() { }

void mi::MDKInit(CMachineDataInput * const pi)
{
	SetOutputMode( false );	//	If true, the MDKWork will never be called, meaning that Buzz will convert a mono signal to
							//	stereo itself and call MDKWorkStereo insted.
							//	If false, MDKWork will be called in mono cases, and the output should be mono
	ex.pmi = this;
	leftgain = 1.0f;
	rightgain = 1.0f;
}

void mi::MDKSave(CMachineDataOutput * const po) { }

void mi::Tick() {
	if (gval.leftgain != 0xFF) {
		leftgain = (gval.leftgain / 254.0f);
	};
	if (gval.rightgain != 0xFF) {
		rightgain = (gval.rightgain / 254.0f);
	};
}

bool mi::MDKWork(float *psamples, int numsamples, int const mode)
{
	if (mode==WM_WRITE)
		return false;
	if (mode==WM_NOIO)
		return false;
	if (mode==WM_READ)		// <thru>
		return true;

	int i;
	for (i = 0; i < numsamples; i++) {
		*psamples++ = thearray[i];
		thearray[i] = 0.0f;
	}

	return true;
}

bool mi::MDKWorkStereo(float *psamples, int numsamples, int const mode)
{
	if (mode==WM_WRITE)
		return false;
	if (mode==WM_NOIO)
		return false;
	if (mode==WM_READ)		// <thru>
		return true;

	int i;
	for (i = 0; i < numsamples; i++) {
		*psamples++ = thearray[i];
		*psamples++ = thearray[i];
		thearray[i] = 0.0f;
	}

	return true;
}

void mi::Command(int const i)
{
	switch (i)
	{
	case 0:
		MessageBox(NULL,"CyanPhase Mono 1.0\n\nCopyright 2000 Edward L. Blake\nEmail: blakee@rovoscape.com\n\nPretty damn easy machine that makes stereo go into mono conveniently","About CyanPhase Mono",MB_OK|MB_SYSTEMMODAL);
		break;
	default:
		break;
	}
}
char const *mi::DescribeValue(int const param, int const value)
{
	static char txt[16];
	switch(param)
	{
	case 0:
		sprintf(txt,"%.1f%%", value/254.0f*100.0f );
		return txt;
		break;
	case 1:
		sprintf(txt,"%.1f%%", value/254.0f*100.0f );
		return txt;
		break;

	default:
		return NULL;
	}
}

#pragma optimize ("", on) 

DLL_EXPORTS

